<?php
// DB config
$host = 'localhost';
$dbname = 'deivis_panelcrm';
$username = 'deivis_panelcrm';
$password = 'deivis_panelcrm';

$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$msg = "";

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['email'])) {
    $email = $_POST['email'];

    // Clear token
    $stmt = $conn->prepare("UPDATE users SET token = NULL WHERE email = ?");
    $stmt->bind_param("s", $email);

    if ($stmt->execute() && $stmt->affected_rows > 0) {
        $msg = "✅ User logged out successfully.";
    } else {
        $msg = "❌ Failed to log out. User may not exist.";
    }

    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Logout User</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: #fff;
            text-align: center;
            margin-top: 100px;
        }
        form {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            display: inline-block;
            color: #333;
            box-shadow: 0 0 15px rgba(0,0,0,0.3);
        }
        input[type="email"] {
            padding: 10px;
            width: 300px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }
        input[type="submit"] {
            padding: 10px 20px;
            background: #2980b9;
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background: #1e6ca5;
        }
    </style>
</head>
<body>

<h2>🔐 Force Logout User</h2>
<form method="POST" action="">
    <input type="email" name="email" placeholder="Enter user email" required><br>
    <input type="submit" value="Logout User">
</form>

<?php if ($msg): ?>
<script>
    Swal.fire({
        title: 'Logout Status',
        text: "<?= $msg ?>",
        icon: "<?= strpos($msg, '✅') !== false ? 'success' : 'error' ?>",
        confirmButtonColor: '#3085d6'
    });
</script>
<?php endif; ?>

</body>
</html>
