<?php
include("include/conn.php");
include("include/function.php");
$login = cekSession();
if ($login == 1) {
    redirect("index.php");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title><?= $brandName ?> | Login</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/ico/favicon.ico">
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.5.2/dist/sweetalert2.min.css"/>

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body, html {
      height: 100%;
      font-family: 'DM Sans', sans-serif;
    }

    .container {
      display: flex;
      height: 100vh;
      width: 100%;
    }

    .left {
      flex: 1;
      background: linear-gradient(to bottom right, #f2f1ff, #fc6f10);
      color: white;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      padding: 50px;
      text-align: center;
    }

    .left h1 {
      font-size: 42px;
      margin-bottom: 20px;
      font-weight: 700;
    }

    .left p {
      font-size: 18px;
      max-width: 400px;
      line-height: 1.5;
    }

    .right {
      flex: 1;
      background: #f9f9f9;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .login-box {
      width: 100%;
      max-width: 420px;
      background: #fff;
      padding: 40px 30px;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
      transition: 0.3s;
    }

    .login-box:hover {
      box-shadow: 0 10px 60px rgba(127, 0, 255, 0.3);
    }

    .login-box h2 {
      font-size: 28px;
      font-weight: 700;
      margin-bottom: 30px;
      text-align: center;
      color: #333;
    }

    .form-group {
      margin-bottom: 25px;
    }

    .form-group label {
      display: block;
      font-size: 14px;
      margin-bottom: 6px;
      color: #555;
    }

    .form-group input {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #ccc;
      border-radius: 10px;
      font-size: 14px;
      transition: 0.3s;
    }

    .form-group input:focus {
      border-color: #FC6F10;
      outline: none;
      box-shadow: 0 0 0 3px rgba(127, 0, 255, 0.1);
    }

    .btn {
      width: 100%;
      padding: 14px;
      border: none;
      background: #FC6F10;
      color: white;
      font-size: 16px;
      border-radius: 10px;
      cursor: pointer;
      transition: 0.3s;
      font-weight: bold;
    }

    .btn:hover {
      background: #5e00d9;
    }

    .links {
      margin-top: 20px;
      text-align: center;
      font-size: 13px;
    }

    .links a {
      color: #FC6F10;
      text-decoration: none;
      margin: 0 10px;
    }

    .footer {
      position: absolute;
      bottom: 10px;
      width: 100%;
      text-align: center;
      font-size: 12px;
      color: #666;
    }

    .footer a {
      color: #FC6F10;
      text-decoration: none;
    }

    @media(max-width: 768px) {
      .container {
        flex-direction: column;
      }

      .left {
        height: 180px;
        padding: 30px;
      }

      .left h1 {
        font-size: 28px;
      }

      .right {
        padding: 20px;
      }
    }
  </style>
</head>
<body>

<div class="container">
<div class="left">
  <img src="login-page/img/logo.svg" alt="Wisender CRm PRO Logo" style="width:250px; margin-bottom: 20px; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);">
  <h1>WHATSAPP CRM PRO</h1>
  <p>CRM de nueva generación con automatización por WhatsApp, marketing inteligente y mucho más.
Impulsa el crecimiento de tu negocio con Wisender CRM PRO.</p>
</div>


 

  <div class="right">
  <div class="login-box">
  <img src="login-page/img/logo.svg" alt="Login Logo" style="width: 250px; margin: 0 auto 20px; display: block; border-radius: 12px;">
  <h2>Inicio de Sesion</h2>
  <form id="login-form">



        <div class="form-group">
          <label for="username">Username</label>
          <input type="text" id="username" name="username" required />
        </div>

        <div class="form-group">
          <label for="password">Password</label>
          <input type="password" id="password" name="password" required />
        </div>

        <input type="submit" class="btn" value="Login" />

        <div class="links">
         
          <a href="policy">Privacy</a> |
          <a href="terms&condistion">Terms</a>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="footer">
  &copy; 2025 WHATSAPP CRM PRO. Reservados todos los derechos.
  <a href="https://wa.me/593988782270" target="_blank">Contactar por WhatsApp</a>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.5.2/dist/sweetalert2.min.js"></script>
<script>
  $(document).ready(function () {
    $('#login-form').submit(function (e) {
      e.preventDefault();

      var formData = {
        username: $('#username').val(),
        password: $('#password').val()
      };

      $.ajax({
        type: 'POST',
        url: 'function/check-login.php',
        data: formData,
        success: function (response) {
          if (response === 'success') {
            Swal.fire({
              title: 'Login Successful!',
              icon: 'success',
              confirmButtonText: 'Continue'
            }).then(() => {
              window.location.href = 'index.php';
            });
          } else {
            Swal.fire({
              title: 'Error',
              text: 'Invalid credentials!',
              icon: 'error',
              confirmButtonText: 'Retry'
            });
          }
        }
      });
    });
  });
</script>

</body>
</html>
