<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Setup</title>
    <style>
        /* General Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            width: 100%;
        }

        h2 {
            text-align: center;
            color: #333;
            font-size: 1.8rem;
            margin-bottom: 20px;
        }

        label {
            color: #555;
            font-size: 1rem;
            margin-bottom: 5px;
            display: block;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
        }

        input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1rem;
        }

        input[type="submit"]:hover {
            background-color: #218838;
        }

        .form-group {
            margin-bottom: 15px;
        }

        @media screen and (max-width: 480px) {
            .container {
                padding: 15px;
            }
            h2 {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Enter Database Details</h2>
        <form method="post" action="">
            <div class="form-group">
                <label for="host">Host:</label>
                <input type="text" id="host" name="host" value="localhost" required>
            </div>

            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>

            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>

            <div class="form-group">
                <label for="dbname">Database Name:</label>
                <input type="text" id="dbname" name="dbname" required>
            </div>

            <input type="submit" name="submit" value="Setup Database">
        </form>
    </div>

    <?php
    if(isset($_POST['submit'])) {
        // Retrieve form data
        $host = $_POST['host'];
        $username = $_POST['username'];
        $password = $_POST['password'];
        $dbname = $_POST['dbname'];

        // Database connection check
        $conn = mysqli_connect($host, $username, $password, $dbname);

        if(!$conn) {
            echo "<script>alert('Error: Unable to connect to database. Please check your details.');</script>";
        } else {
            // SQL File Path (update with your actual SQL file path)
            $sql_file = 'database.sql';  // Replace with your SQL file path

            // Read SQL File
            $sql_content = file_get_contents($sql_file);

            if($sql_content) {
                // Execute SQL Queries
                $sql_queries = explode(';', $sql_content); // Split queries by semicolon
                foreach($sql_queries as $query) {
                    if(trim($query) != '') {
                        mysqli_query($conn, $query);
                    }
                }
            }

            // Create config.php file
            $config_content = "<?php\n";
            $config_content .= "\$DBCON['host'] = '$host';\n";
            $config_content .= "\$DBCON['user'] = '$username';\n";
            $config_content .= "\$DBCON['pass'] = '$password';\n";
            $config_content .= "\$DBCON['name'] = '$dbname';\n";
            $config_content .= "?>";

            if(file_put_contents('include/config.php', $config_content)) {
                // Config file created successfully
            }

            // Create conn.php file
            $conn_content = "<?php\n";
            $conn_content .= "date_default_timezone_set('Asia/Calcutta');\n";
            $conn_content .= "\$host = '$host';\n";
            $conn_content .= "\$username = '$username';\n";
            $conn_content .= "\$password = '$password';\n";
            $conn_content .= "\$db = '$dbname';\n";
            $conn_content .= "error_reporting(1);\n";
            $conn_content .= "\$conn = mysqli_connect(\$host, \$username, \$password, \$db) or die('Failed To Connect Database! 02H');\n";
            $conn_content .= "\$app_name = 'WCRM';\n";
            $conn_content .= "\$c_name = 'WCRM';\n";
            $conn_content .= "?>";

            if(file_put_contents('include/conn.php', $conn_content)) {
                // Connection file created successfully
            }

            // Close the database connection
            mysqli_close($conn);

            // Redirect to index.php
            echo "<script>window.location.href = 'index.php';</script>";
        }
    }
    ?>
</body>
</html>
