<?php
include("include/conn.php");
include("include/function.php");

// Check session and redirect if not logged in
$login = cekSession();
if ($login != 1) {
    redirect("login.php");
}

// Fetch license details
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    $stmt = $conn->prepare("SELECT `id`, `customer_name`, `whatsapp_number`, `email`, `password`, `end_date`, `status` FROM `users` WHERE `id` = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $license = $result->fetch_assoc();

    if (!$license) {
        echo "License not found!";
        exit;
    }
} else {
    echo "No license ID provided!";
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_name = $_POST['customer_name'];
    $whatsapp_number = $_POST['whatsapp_number'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $end_date = $_POST['end_date'];
    $status = 'true';
    $datetime = date('Y-m-d H:i:s', strtotime($end_date));

    $stmt = $conn->prepare("UPDATE `users` SET `customer_name` = ?, `whatsapp_number` = ?, `email` = ?, `password` = ?, `end_date` = ?, `status` = ? WHERE `id` = ?");
    $stmt->bind_param("ssssssi", $customer_name, $whatsapp_number, $email, $password, $datetime, $status, $id);

    if ($stmt->execute()) {
        header("Location: all-licenses.php");
        exit;
    } else {
        echo "Error updating license: " . $stmt->error;
    }
}
?>
<!DOCTYPE html>
<html lang="es" data-textdirection="ltr">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>Editar Licencia</title>
    <link rel="apple-touch-icon" href="assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">
    <link href="https://maxcdn.icons8.com/fonts/line-awesome/1.1/css/line-awesome.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/css/vendors.css">
    <link rel="stylesheet" type="text/css" href="assets/css/app-lite.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/colors/palette-gradient.css">
    <style>
        .content-wrapper {
            background-color: #f3f4f6;
        }

        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: transparent;
            border-bottom: 1px solid #e5e7eb;
            padding: 1.5rem;
        }
        
        .card-title {
             font-weight: 600;
             color: #1f2937;
        }
        .form-control {
            border-radius: 8px;
            border: 1px solid #d1d5db;
            padding: 0.75rem 1rem;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
        }
        .form-control:focus {
            color: #495057;
            background-color: #fff;
            border-color: #4f46e5;
            outline: 0;
            box-shadow: 0 0 0 0.2rem rgb(79 70 229 / 25%);
        }
        .btn-primary {
            color: #fff;
            background-color: #4f46e5;
            border-color: #4f46e5;
            border-radius: 8px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
        }
        .btn-secondary {
            border-radius: 8px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
        }
        #password-toggle {
            cursor: pointer;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu 2-columns menu-expanded fixed-navbar" data-open="click" data-menu="vertical-menu" data-color="bg-gradient-x-purple-blue" data-col="2-columns">
    <?php include("include/header.php"); ?>
    <?php include("include/sidebar.php"); ?>

    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-wrapper-before" style="background:none;"></div>
            <div class="content-header row">
                <div class="content-header-left col-md-4 col-12 mb-2">
                    <h3 class="content-header-title" style="color: #1f2937; font-weight: 700;">Editar Licencia</h3>
                </div>
                <div class="content-header-right col-md-8 col-12">
                    <div class="breadcrumbs-top float-md-right">
                        <div class="breadcrumb-wrapper mr-1">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.php">Inicio</a></li>
                                <li class="breadcrumb-item"><a href="all-licenses.php">Todas las Licencias</a></li>
                                <li class="breadcrumb-item active">Editar Licencia</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Detalles de la Licencia</h4>
                            </div>
                            <div class="card-body">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="customer_name" class="font-weight-bold">Nombre del Cliente</label>
                                        <input type="text" class="form-control" id="customer_name" name="customer_name" value="<?php echo htmlspecialchars($license['customer_name']); ?>" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="whatsapp_number" class="font-weight-bold">Número de Whatsapp</label>
                                        <input type="text" class="form-control" id="whatsapp_number" name="whatsapp_number" value="<?php echo htmlspecialchars($license['whatsapp_number']); ?>" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="email" class="font-weight-bold">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($license['email']); ?>" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="password" class="font-weight-bold">Contraseña</label>
                                        <div class="input-group">
                                            <input type="password" class="form-control" id="password" name="password" value="<?php echo htmlspecialchars($license['password']); ?>" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="password-toggle"><i class="la la-eye"></i></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="end_date" class="font-weight-bold">Fecha y Hora de Vencimiento</label>
                                        <input type="datetime-local" class="form-control" id="end_date" name="end_date" value="<?php echo date('Y-m-d\TH:i', strtotime($license['end_date'])); ?>" required>
                                    </div>

                                    <input type="hidden" name="status" value="true">

                                    <button type="submit" class="btn btn-primary">Actualizar Licencia</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include("include/footer.php"); ?>
    
    <script src="assets/vendors/js/vendors.min.js" type="text/javascript"></script>
    <script src="assets/js/core/app-menu-lite.js" type="text/javascript"></script>
    <script src="assets/js/core/app-lite.js" type="text/javascript"></script>
    
    <script>
        const passwordToggle = document.getElementById('password-toggle');
        const passwordInput = document.getElementById('password');
        passwordToggle.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            this.querySelector('i').classList.toggle('la-eye');
            this.querySelector('i').classList.toggle('la-eye-slash');
        });
    </script>
</body>

</html>

