<?php
/**
 * add-license-proxy_v2.php
 * - Versin modificada para funcionar SIN cURL, usando file_get_contents.
 * - Ubicacin prevista: /crm-pro2/demos/_demo-correo/
 * - Inicia sesin va function/check-login.php
 * - Luego llama function/generate-license.php con los campos requeridos
 */

header('Content-Type: application/json');

// --- CONFIGURACI07N ---
$siteBase  = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'];
$panelBase = rtrim(dirname(dirname(dirname($_SERVER['SCRIPT_NAME']))), '/'); // Debera ser /crm-pro2

$loginApi  = $siteBase . $panelBase . '/function/check-login.php';
$genApi    = $siteBase . $panelBase . '/function/generate-license.php';

// --- VALIDACI07N DE ENTRADA ---
$user = isset($_SERVER['HTTP_USERNAME']) ? trim($_SERVER['HTTP_USERNAME']) : '';
$pass = isset($_SERVER['HTTP_PASSWORD']) ? trim($_SERVER['HTTP_PASSWORD']) : '';

if ($user === '' || $pass === '') {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Missing username/password headers']);
    exit;
}

$required = ['wnumber', 'cname', 'email', 'password', 'endDate', 'validity'];
foreach ($required as $f) {
    if (!isset($_POST[$f]) || $_POST[$f] === '') {
        http_response_code(400);
        echo json_encode(['status' => false, 'message' => "Missing field: $f"]);
        exit;
    }
}

$postData = $_POST;

// --- PASO 1: INICIO DE SESI07N ---

// Preparamos los datos y las cabeceras para el login
$loginPostData = http_build_query([
    'username' => $user,
    'password' => $pass
]);

$loginHeaders = [
    'Content-Type: application/x-www-form-urlencoded',
    'User-Agent: Mozilla/5.0',
    'Referer: ' . $siteBase . $panelBase . '/login.php'
];

// Configuramos el contexto para la llamada HTTP
$loginContext = stream_context_create([
    'http' => [
        'method'  => 'POST',
        'header'  => implode("\r\n", $loginHeaders),
        'content' => $loginPostData,
        'ignore_errors' => true // Para poder leer la respuesta aunque haya un error HTTP
    ],
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
    ]
]);

// Realizamos la llamada
$loginResp = file_get_contents($loginApi, false, $loginContext);

// Analizamos la respuesta
if ($loginResp === false) {
    http_response_code(502);
    echo json_encode(['status' => false, 'message' => 'Login request failed. file_get_contents could not reach the server.']);
    exit;
}

// Extraemos el cdigo de estado y las cookies de la respuesta
$loginStatusCode = 0;
$sessionCookie = '';
if (isset($http_response_header) && is_array($http_response_header)) {
    // Extraer cdigo de estado
    if (preg_match('{HTTP\/\S*\s(\d{3})}', $http_response_header[0], $match)) {
        $loginStatusCode = (int)$match[1];
    }
    // Extraer la cookie de sesin para usarla en la siguiente llamada
    foreach ($http_response_header as $header) {
        if (stripos($header, 'Set-Cookie:') === 0) {
            $cookieValue = substr($header, strlen('Set-Cookie: '));
            // Extraemos solo la parte 'PHPSESSID=...'
            $sessionCookie = explode(';', $cookieValue)[0];
            break;
        }
    }
}

if (trim($loginResp) !== 'success' || $sessionCookie === '') {
    http_response_code($loginStatusCode ?: 403);
    echo json_encode(['status' => false, 'message' => 'Login failed. Check credentials.', 'raw' => $loginResp]);
    exit;
}

// --- PASO 2: LLAMADA AL GENERADOR DE LICENCIAS ---

// Preparamos los datos y cabeceras para la segunda llamada
$generatePostData = http_build_query($postData);

$generateHeaders = [
    'Content-Type: application/x-www-form-urlencoded',
    'User-Agent: Mozilla/5.0',
    'Referer: ' . $siteBase . $panelBase . '/add-license.php',
    'Accept: application/json',
    'Cookie: ' . $sessionCookie // 03Aqu usamos la cookie de sesin obtenida!
];

// Configuramos el contexto
$generateContext = stream_context_create([
    'http' => [
        'method'  => 'POST',
        'header'  => implode("\r\n", $generateHeaders),
        'content' => $generatePostData,
        'ignore_errors' => true
    ],
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
    ]
]);

// Realizamos la segunda llamada
$resp = file_get_contents($genApi, false, $generateContext);

if ($resp === false) {
    http_response_code(502);
    echo json_encode(['status' => false, 'message' => 'Generate license request failed.']);
    exit;
}

// Obtenemos el cdigo de estado de la segunda respuesta
$generateStatusCode = 0;
if (isset($http_response_header) && is_array($http_response_header)) {
    if (preg_match('{HTTP\/\S*\s(\d{3})}', $http_response_header[0], $match)) {
        $generateStatusCode = (int)$match[1];
    }
}

// --- RESPUESTA FINAL ---

// Normalizamos la respuesta JSON
$json = json_decode($resp, true);
if ($json === null) {
    http_response_code($generateStatusCode ?: 200);
    echo json_encode(['status' => false, 'message' => 'Non-JSON response from generator', 'raw' => $resp]);
    exit;
}

http_response_code($generateStatusCode ?: 200);
echo json_encode($json);

?>
