<?php
include("include/conn.php");
include("include/function.php");
$login = cekSession();
if ($login != 1) {
    redirect("login.php");
}

?>
<!DOCTYPE html>
<html class="loading" lang="es" data-textdirection="ltr">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title id="title"><?= $brandName ?> | Añadir Admin</title>
    <link rel="apple-touch-icon" href="assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">
    <link href="https://maxcdn.icons8.com/fonts/line-awesome/1.1/css/line-awesome.min.css" rel="stylesheet">
    
    <link rel="stylesheet" type="text/css" href="assets/css/vendors.css">
    <link rel="stylesheet" type="text/css" href="assets/css/app-lite.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/colors/palette-gradient.css">
    <link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">

    <style>
        .content-wrapper { background-color: #f3f4f6; }
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
        }
        .card-header {
            background-color: transparent;
            border-bottom: 1px solid #e5e7eb;
            padding: 1.5rem;
        }
        .card-title { font-weight: 600; color: #1f2937; }
        .form-control {
            border-radius: 8px;
            border: 1px solid #d1d5db;
            padding: 0.75rem 1rem;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
        }
        .form-control:focus {
            color: #495057;
            background-color: #fff;
            border-color: #4f46e5;
            outline: 0;
            box-shadow: 0 0 0 0.2rem rgb(79 70 229 / 25%);
        }
        .btn-primary {
            color: #fff;
            background-color: #4f46e5;
            border-color: #4f46e5;
            border-radius: 8px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
        }
        #password-toggle { cursor: pointer; }
    </style>
</head>

<body class="vertical-layout vertical-menu 2-columns menu-expanded fixed-navbar" data-open="click" data-menu="vertical-menu" data-color="bg-gradient-x-purple-blue" data-col="2-columns">
    <?php include("include/header.php"); ?>
    <?php include("include/sidebar.php"); ?>

    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-wrapper-before" style="background:none;"></div>
            <div class="content-header row">
                <div class="content-header-left col-md-4 col-12 mb-2">
                    <h3 class="content-header-title" style="color: #1f2937; font-weight: 700;">Añadir Admin</h3>
                </div>
                <div class="content-header-right col-md-8 col-12">
                    <div class="breadcrumbs-top float-md-right">
                        <div class="breadcrumb-wrapper mr-1">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.php">Inicio</a></li>
                                <li class="breadcrumb-item active">Añadir Admin</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Información del Nuevo Admin</h4>
                            </div>
                            <div class="card-body">
                                <form id="admin-form">
                                    <div class="form-group">
                                        <label for="cname" class="font-weight-bold">Nombre Completo</label>
                                        <input type="text" class="form-control" id="cname" name="cname" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="wnumber" class="font-weight-bold">Número de Whatsapp</label>
                                        <input type="number" class="form-control" id="wnumber" name="wnumber" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="username" class="font-weight-bold">Nombre de Usuario</label>
                                        <input type="text" class="form-control" id="username" name="username" required>
                                    </div>

                                    <div class="form-group">
                                        <label for="password" class="font-weight-bold">Contraseña</label>
                                         <div class="input-group">
                                            <input type="password" class="form-control" id="password" name="password" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="password-toggle"><i class="la la-eye"></i></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="start_date" class="font-weight-bold">Fecha de Inicio</label>
                                                <input type="text" class="form-control datepicker" id="start_date" name="start_date" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="expired_date" class="font-weight-bold">Fecha de Expiración</label>
                                                <input type="text" class="form-control datepicker" id="expired_date" name="expired_date" required>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary mt-2">Añadir Admin</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include("include/footer.php"); ?>
    
    <script src="assets/vendors/js/vendors.min.js" type="text/javascript"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="assets/js/core/app-menu-lite.js" type="text/javascript"></script>
    <script src="assets/js/core/app-lite.js" type="text/javascript"></script>

    <script>
    $(document).ready(function() {
        $('.datepicker').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: 0
        });

        $('#admin-form').on('submit', function(e) {
            e.preventDefault();

            var cname = $('#cname').val();
            var wnumber = $('#wnumber').val();
            var username = $('#username').val();
            var password = $('#password').val();
            var startDate = $('#start_date').val();
            var expiredDate = $('#expired_date').val();

            if (!cname || !wnumber || !username || !password || !startDate || !expiredDate) {
                 Swal.fire('Error', 'Por favor, complete todos los campos.', 'error');
                 return;
            }

            $.ajax({
                url: 'function/add-admin.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    cname: cname,
                    wnumber: wnumber,
                    username: username,
                    password: password,
                    start_date: startDate,
                    expired_date: expiredDate,
                    user_type: 'user',
                    status: true
                },
                success: function(response) {
                    if (response.status) {
                        Swal.fire('¡Éxito!', response.message, 'success').then(() => {
                           $('#admin-form')[0].reset();
                        });
                    } else {
                        Swal.fire('Error', response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Error', 'Ocurrió un error al procesar la solicitud.', 'error');
                }
            });
        });
        
        const passwordToggle = document.getElementById('password-toggle');
        const passwordInput = document.getElementById('password');
        passwordToggle.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            this.querySelector('i').classList.toggle('la-eye');
            this.querySelector('i').classList.toggle('la-eye-slash');
        });
    });
    </script>
</body>
</html>
