<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if (!isset($_GET['wl_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "Missing wl_id",
        "wl" => null
    ]);
    exit;
}

$wl_id = $_GET['wl_id'];

// DB config
$host = 'localhost';
$db = 'XXXXX';
$user = 'XXXXXXXXXX';
$pass = 'XXXXXXXXXXXXXX';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed",
        "wl" => null
    ]);
    exit;
}

// Check if device exists in user_devices table
$stmt = $conn->prepare("SELECT id FROM user_devices WHERE chrome_store_id = ?");
$stmt->bind_param("s", $wl_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        "success" => false,
        "message" => "Device not found",
        "wl" => null
    ]);
    exit;
}

// If found, respond with wl object
$response = [
  "success" => true,
  "message" => "WL capturada",
  "wl" => [
    "id" => $wl_id,
    "checkout" => "https://www.google.com/",
    "tutorial" => "https://www.youtube.com/",
    "webhook" => "https://n8n.manyflux.com.br/webhook/novocliente",
    "cor_primaria" => 0,
    "banner" => null,
    "status" => "ACTIVE",
    "install" => "https://https://www.google.com/",
    "uninstall" => "https://https://www.google.com/",
    "rewards" => "https://https://www.google.com/",
    "suporte" => "https://api.whatsapp.com/send/?phone=9998&text=Ol%C3%A1+desejo+suporte",
    "webhook_login_clients" => "https://n8n.manyflux.com.br/webhook/64c4296d-61d8-4271-9ff2-1aa44c8a192c ",
    "ia_wascript" => "https://https://www.google.com/",
    "meetAovivo" => [
      "users" => "ALL",
      "aoVivo" => true,
      "online" => [
        "title" => "📢 Estamos ao Vivo!",
        "btnName" => "🔗 Acesse a apresentação aqui:",
        "urlMeet" => "https://meet.google.com/ffj-xdtc-my",
        "description" => "Hoje teremos nossa live semanal às 15 horas. Já salve nosso link para aprender mais sobre nossa ferramenta!\n\nEm geral nossa live finaliza às 16 horas e te ajuda bastante e conhecer mais nossas ferramentas!\n\nAproveite para tirar suas dúvidas online!"
      ],
      "offline" => [
        "title" => "",
        "active" => false,
        "description" => "",
        "suportRedirect" => false
      ],
      "fusoHorario" => "America/Sao_Paulo",
      "activationDays" => [
        "sexta" => [
          "active" => true,
          "start_time" => "14:30",
          "finish_time" => "16:00"
        ],
        "terca" => [
          "active" => false,
          "start_time" => "",
          "finish_time" => ""
        ],
        "quarta" => [
          "active" => false,
          "start_time" => "11:04",
          "finish_time" => "11:19"
        ],
        "quinta" => [
          "active" => false,
          "start_time" => "",
          "finish_time" => ""
        ],
        "sabado" => [
          "active" => false,
          "start_time" => "",
          "finish_time" => ""
        ],
        "domingo" => [
          "active" => false,
          "start_time" => "00:00",
          "finish_time" => "00:00"
        ],
        "segunda" => [
          "active" => false,
          "start_time" => "",
          "finish_time" => ""
        ]
      ]
    ],
   "suporte_clientes" => [
  "free" => "https://api.whatsapp.com/send/?phone=%2B999&text=Hello%2C%20I%20need%20support%20I%20am%20using%20waBaCRM",
  "premium" => "https://api.whatsapp.com/send/?phone=%2B999&text=Hello%2C%20I%20need%20support%20I%20am%20using%20waBaCRM"
]



    ]
 
];

echo json_encode($response);

$stmt->close();
$conn->close();
?>
