<?php
$host = "localhost";
$dbname = "ahfirfmp_admin01";
$username = "ahfirfmp_admin01";
$password = "ahfirfmp_admin01";

$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$user = null;
$msg = "";
$showAlert = false;

// Fetch user
if (isset($_GET['email'])) {
    $email = $_GET['email'];
    $stmt = $conn->prepare("SELECT id, email, plan_expiry_date, max_devices FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

// Update
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $new_expiry = $_POST['plan_expiry_date'];
    $new_max_devices = $_POST['max_devices'];

    $stmt = $conn->prepare("UPDATE users SET plan_expiry_date = ?, max_devices = ? WHERE email = ?");
    $stmt->bind_param("sis", $new_expiry, $new_max_devices, $email);
    if ($stmt->execute()) {
        $msg = "User data updated successfully.";
        $showAlert = true;
    } else {
        $msg = "Error updating user: " . $stmt->error;
        $showAlert = true;
    }
    $stmt->close();
    $user = ['email' => $email, 'plan_expiry_date' => $new_expiry, 'max_devices' => $new_max_devices];
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit User - Admin Panel</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 420px;
            margin: 60px auto;
            background: #fff;
            padding: 30px 40px;
            border-radius: 10px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.2);
            text-align: center;
        }

        h2 {
            color: #2c3e50;
            margin-bottom: 20px;
        }

        input[type="email"],
        input[type="date"],
        input[type="number"] {
            width: 100%;
            padding: 12px 14px;
            margin: 10px 0 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
        }

        input[type="submit"] {
            background-color: #2a5298;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
        }

        input[type="submit"]:hover {
            background-color: #1e3c72;
        }

        .search-form {
            text-align: center;
            margin-top: 40px;
        }

        .search-form input[type="email"] {
            width: 300px;
            padding: 10px;
            border-radius: 6px;
            border: 1px solid #ccc;
        }

        .search-form input[type="submit"] {
            padding: 10px 16px;
            background-color: #2980b9;
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
    </style>
</head>
<body>

<?php if (!$user): ?>
    <div class="search-form">
        <h2>🔍 Search User by Email</h2>
        <form method="get" action="">
            <input type="email" name="email" placeholder="Enter user email" required>
            <input type="submit" value="Search">
        </form>
    </div>
<?php else: ?>
    <div class="container">
        <h2>Edit User: <?= htmlspecialchars($user['email']) ?></h2>
        <form method="post" action="">
            <input type="hidden" name="email" value="<?= htmlspecialchars($user['email']) ?>">
            Plan Expiry Date: <br>
            <input type="date" name="plan_expiry_date" value="<?= $user['plan_expiry_date'] ?>" required><br>
            Max Devices: <br>
            <input type="number" name="max_devices" value="<?= $user['max_devices'] ?>" required><br>
            <input type="submit" value="Update User">
        </form>
    </div>
<?php endif; ?>

<?php if ($showAlert): ?>
<script>
    Swal.fire({
        icon: "<?= strpos($msg, 'Error') !== false ? 'error' : 'success' ?>",
        title: "<?= strpos($msg, 'Error') !== false ? 'Oops!' : 'Success' ?>",
        text: "<?= $msg ?>",
        confirmButtonColor: '#3085d6',
    });
</script>
<?php endif; ?>

</body>
</html>
