<?php
include("include/conn.php");
include("include/function.php");

$login = cekSession();
if ($login != 1) {
    redirect("login.php");
}

$user_id = $_SESSION['id'];
$user_type = $_SESSION['user_type'];

// Function to get counts based on user type
function getCounts($conn, $user_id, $user_type)
{
    $counts = array();

    if ($user_type === 'admin') {
        // Admin dashboard data
        $totalUsersQuery = "SELECT COUNT(*) AS total_users FROM admin";
        $totalLicensesQuery = "SELECT COUNT(*) AS total_licenses FROM users WHERE deleted_key != 'yes'";
        $totalInactiveLicensesQuery = "SELECT COUNT(*) AS total_inactive_licenses FROM users WHERE status = 'false' AND deleted_key != 'yes'";
        $totalActiveLicensesQuery = "SELECT COUNT(*) AS total_active_licenses FROM users WHERE status = 'true' AND deleted_key != 'yes'";
        $totalResellersQuery = "SELECT COUNT(*) AS total_resellers FROM admin WHERE user_type = 'reseller'AND deleted = 'no'";

        $counts['total_users'] = mysqli_fetch_assoc(mysqli_query($conn, $totalUsersQuery))['total_users'];
        $counts['total_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalLicensesQuery))['total_licenses'];
        $counts['total_inactive_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalInactiveLicensesQuery))['total_inactive_licenses'];
        $counts['total_active_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalActiveLicensesQuery))['total_active_licenses'];
        $counts['total_resellers'] = mysqli_fetch_assoc(mysqli_query($conn, $totalResellersQuery))['total_resellers'];
    } elseif ($user_type === 'user') {
        $totalUsersQuery = "
        SELECT COUNT(*) AS total_users 
        FROM admin 
        WHERE admin_id = $user_id OR id = $user_id
    ";
        $totalLicensesQuery = "
    SELECT COUNT(*) AS total_licenses 
    FROM users 
    WHERE deleted_key != 'yes' 
    AND (user_id = $user_id OR user_id IN (SELECT id FROM admin WHERE admin_id = $user_id AND user_type != 'user'))
";
        $totalInactiveLicensesQuery = "
    SELECT COUNT(*) AS total_inactive_licenses 
    FROM users 
    WHERE status = 'false' 
    AND deleted_key != 'yes' 
    AND (user_id = $user_id OR user_id IN (SELECT id FROM admin WHERE admin_id = $user_id AND user_type != 'user'))
";
        $totalActiveLicensesQuery = "
    SELECT COUNT(*) AS total_active_licenses 
    FROM users 
    WHERE status = 'true' 
    AND deleted_key != 'yes' 
    AND (user_id = $user_id OR user_id IN (SELECT id FROM admin WHERE admin_id = $user_id AND user_type != 'user'))
";
        $totalResellersQuery = "
        SELECT COUNT(*) AS total_resellers 
        FROM admin 
        WHERE user_type = 'reseller' AND deleted = 'no'
        AND admin_id = $user_id
    ";

        $counts['total_users'] = mysqli_fetch_assoc(mysqli_query($conn, $totalUsersQuery))['total_users'];
        $counts['total_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalLicensesQuery))['total_licenses'];
        $counts['total_inactive_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalInactiveLicensesQuery))['total_inactive_licenses'];
        $counts['total_active_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalActiveLicensesQuery))['total_active_licenses'];
        $counts['total_resellers'] = mysqli_fetch_assoc(mysqli_query($conn, $totalResellersQuery))['total_resellers'];
    } else {
        // Reseller dashboard data
        $totalLicensesQuery = "SELECT COUNT(*) AS total_licenses FROM users WHERE user_id = '$user_id'AND deleted_key != 'yes'";
        $totalInactiveLicensesQuery = "SELECT COUNT(*) AS total_inactive_licenses FROM users WHERE user_id = '$user_id' AND status = 'false' AND deleted_key != 'yes' ";
        $totalActiveLicensesQuery = "SELECT COUNT(*) AS total_active_licenses FROM users WHERE user_id = '$user_id' AND status = 'true'AND deleted_key != 'yes'";

        $counts['total_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalLicensesQuery))['total_licenses'];
        $counts['total_inactive_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalInactiveLicensesQuery))['total_inactive_licenses'];
        $counts['total_active_licenses'] = mysqli_fetch_assoc(mysqli_query($conn, $totalActiveLicensesQuery))['total_active_licenses'];
    }

    return $counts;
}

$dashboardData = getCounts($conn, $user_id, $user_type);
?>
<!DOCTYPE html>
<html class="loading" lang="es" data-textdirection="ltr">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title><?= isset($brandName) ? $brandName : 'Panel' ?> | Dashboard</title>
    <link rel="apple-touch-icon" href="assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">
    <link href="https://maxcdn.icons8.com/fonts/line-awesome/1.1/css/line-awesome.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/css/vendors.css">
    <link rel="stylesheet" type="text/css" href="assets/css/app-lite.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/colors/palette-gradient.css">
    <style>
        /* Estilos personalizados para las tarjetas rediseñadas */
        .stat-card .card-body {
            display: flex;
            align-items: center;
            padding: 1.25rem;
        }
        .stat-card .icon-bg {
            padding: 0.8rem;
            margin-right: 1.25rem;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .stat-card .icon-bg svg {
            width: 28px;
            height: 28px;
        }
        .stat-card .stat-info .stat-title {
            font-size: 0.9rem;
            color: #6c757d;
            margin-bottom: 0.25rem;
            font-weight: 500;
        }
        .stat-card .stat-info .stat-number {
            font-size: 1.6rem;
            font-weight: 600;
            color: #343a40;
        }
        .stat-card-link {
            color: inherit;
            text-decoration: none;
            display: flex;
            width: 100%;
            align-items: center;
        }
        .stat-card .card {
            transition: all 0.2s ease-in-out;
            border: 0;
            box-shadow: 0 4px 15px -4px rgba(0,0,0,0.08);
        }
        .stat-card .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 30px -8px rgba(0,0,0,0.15);
        }

        /* Colores de los iconos */
        .icon-bg-blue { background-color: #e6f2ff; color: #007bff; }
        .icon-bg-green { background-color: #e9f9ee; color: #28a745; }
        .icon-bg-yellow { background-color: #fff9e6; color: #ffc107; }
        .icon-bg-teal { background-color: #e3fafc; color: #17a2b8; }
        .icon-bg-indigo { background-color: #f0edff; color: #6610f2; }

        /* Contenedor del Banner Slider */
        .banner-slider {
            position: relative;
            width: 100%;
            overflow: hidden;
            border-radius: .5rem;
        }
        .slides {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }
        .slide {
            min-width: 100%;
            box-sizing: border-box;
        }
        .slide img {
            width: 100%;
            height: auto;
        }
        .prev, .next {
            cursor: pointer;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: auto;
            padding: 12px;
            color: white;
            font-weight: bold;
            font-size: 18px;
            transition: 0.4s ease;
            border-radius: 50%;
            user-select: none;
            background-color: rgba(0,0,0,0.25);
            width: 44px;
            height: 44px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .next { right: 1rem; }
        .prev { left: 1rem; }
        .prev:hover, .next:hover { background-color: rgba(0,0,0,0.5); }
    </style>
</head>
<body class="vertical-layout vertical-menu 2-columns menu-expanded fixed-navbar" data-open="click" data-menu="vertical-menu" data-color="bg-gradient-x-purple-blue" data-col="2-columns">

    <?php include("include/header.php"); ?>
    <?php include("include/sidebar.php"); ?>

    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-wrapper-before"></div>
            <div class="content-header row">
                <div class="content-header-left col-md-4 col-12 mb-2">
                    <h3 class="content-header-title">Dashboard</h3>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <?php if ($user_type === 'admin' || $user_type === 'user') : ?>
                        <!-- Total Users -->
                        <div class="col-lg-4 col-md-6 col-12 stat-card">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body">
                                        <div class="icon-bg icon-bg-blue">
                                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M15 21a6 6 0 00-9-5.197M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                        </div>
                                        <div class="stat-info">
                                            <p class="stat-title">Total de Usuarios</p>
                                            <p class="stat-number"><?php echo $dashboardData['total_users']; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Licenses -->
                    <div class="col-lg-4 col-md-6 col-12 stat-card">
                         <div class="card">
                            <div class="card-content">
                                <a href="all-licenses.php" class="card-body stat-card-link">
                                    <div class="icon-bg icon-bg-green">
                                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path></svg>
                                    </div>
                                    <div class="stat-info">
                                        <p class="stat-title">Total de Licencias</p>
                                        <p class="stat-number"><?php echo $dashboardData['total_licenses']; ?></p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Total Inactive Licenses -->
                    <div class="col-lg-4 col-md-6 col-12 stat-card">
                        <div class="card">
                           <div class="card-content">
                               <a href="all-inactivelicenses.php" class="card-body stat-card-link">
                                   <div class="icon-bg icon-bg-yellow">
                                       <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                   </div>
                                   <div class="stat-info">
                                       <p class="stat-title">Licencias Inactivas</p>
                                       <p class="stat-number"><?php echo $dashboardData['total_inactive_licenses']; ?></p>
                                   </div>
                               </a>
                           </div>
                       </div>
                   </div>

                    <!-- Total Active Licenses -->
                    <div class="col-lg-4 col-md-6 col-12 stat-card">
                        <div class="card">
                           <div class="card-content">
                               <a href="all-activelicenses.php" class="card-body stat-card-link">
                                   <div class="icon-bg icon-bg-teal">
                                       <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M5 13l4 4L19 7"></path></svg>
                                   </div>
                                   <div class="stat-info">
                                       <p class="stat-title">Licencias Activas</p>
                                       <p class="stat-number"><?php echo $dashboardData['total_active_licenses']; ?></p>
                                   </div>
                               </a>
                           </div>
                       </div>
                   </div>

                    <?php if ($user_type === 'admin' || $user_type === 'user') : ?>
                        <!-- Total Resellers -->
                        <div class="col-lg-4 col-md-6 col-12 stat-card">
                            <div class="card">
                               <div class="card-content">
                                   <a href="all-reseller.php" class="card-body stat-card-link">
                                       <div class="icon-bg icon-bg-indigo">
                                           <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.653-.124-1.28-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.653.124-1.28.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                       </div>
                                       <div class="stat-info">
                                           <p class="stat-title">Total de Revendedores</p>
                                           <p class="stat-number"><?php echo $dashboardData['total_resellers']; ?></p>
                                       </div>
                                   </a>
                               </div>
                           </div>
                       </div>
                    <?php endif; ?>
                </div>

                <!-- Banner Slider -->
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="banner-slider">
                            <div class="slides">
                                <div class="slide">
                                    <a href="https://wisender.net/" target="_blank">
                                        <img src="assets/slider/WabaCRM-Logo-Without-Background.png" alt="Banner 1">
                                    </a>
                                </div>
                                <div class="slide">
                                    <a href="#" target="_blank">
                                        <img src="assets/slider/Screenshot 2025-05-31 222706.png" alt="Banner 2">
                                    </a>
                                </div>
                                <div class="slide">
                                    <a href="#" target="_blank">
                                        <img src="assets/slider/Screenshot 2025-05-31 222313.png" alt="Banner 3">
                                    </a>
                                </div>
                            </div>
                            <a class="prev" onclick="moveSlide(-1)">&#10094;</a>
                            <a class="next" onclick="moveSlide(1)">&#10095;</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include("include/footer.php"); ?>

    <script src="assets/vendors/js/vendors.min.js" type="text/javascript"></script>
    <script src="assets/js/core/app-menu-lite.js" type="text/javascript"></script>
    <script src="assets/js/core/app-lite.js" type="text/javascript"></script>
    <script>
        let currentSlideIndex = 0;
        const slidesContainer = document.querySelector('.slides');
        const slides = document.querySelectorAll('.slide');

        function moveSlide(direction) {
            const totalSlides = slides.length;
            if (totalSlides === 0) return;
            currentSlideIndex = (currentSlideIndex + direction + totalSlides) % totalSlides;
            slidesContainer.style.transform = `translateX(${-currentSlideIndex * 100}%)`;
        }
        
        setInterval(() => {
            moveSlide(1);
        }, 3000);
    </script>
    <script disable-devtool-auto="" src="https://pay.imb.org.in/Qrcode/disable-devtool.js" data-url="https://www.google.com/"></script> 
</body>
</html>

