<?php
/**
 * add-license-proxy_v2.php
 * - Versión definitiva que funciona en hostings restrictivos (sin cURL ni allow_url_fopen).
 * - En lugar de hacer llamadas HTTP, incluye los archivos PHP locales directamente.
 */

// Iniciar la sesión es crucial para que el login y la generación funcionen.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');

// --- CÁLCULO DE RUTAS ---
// Obtenemos la ruta raíz del documento en el sistema de archivos.
$docRoot = $_SERVER['DOCUMENT_ROOT'];
// Obtenemos la ruta base del panel (ej: /crm-pro2)
$panelBase = rtrim(dirname(dirname(dirname($_SERVER['SCRIPT_NAME']))), '/');

// Construimos las rutas de archivo locales en lugar de URLs.
$loginScriptPath = $docRoot . $panelBase . '/function/check-login.php';
$genScriptPath   = $docRoot . $panelBase . '/function/generate-license.php';

// Verificamos que los archivos existan para evitar errores fatales.
if (!file_exists($loginScriptPath) || !file_exists($genScriptPath)) {
    http_response_code(500);
    echo json_encode(['status' => false, 'message' => 'Error: Script paths are incorrect. Cannot find target files.']);
    exit;
}

// --- VALIDACIÓN DE ENTRADA ---
$user = isset($_SERVER['HTTP_USERNAME']) ? trim($_SERVER['HTTP_USERNAME']) : '';
$pass = isset($_SERVER['HTTP_PASSWORD']) ? trim($_SERVER['HTTP_PASSWORD']) : '';

if ($user === '' || $pass === '') {
    http_response_code(401);
    echo json_encode(['status' => false, 'message' => 'Missing username/password headers']);
    exit;
}

$required = ['wnumber', 'cname', 'email', 'password', 'endDate', 'validity'];
$originalPostData = $_POST; // Guardamos los datos originales.
foreach ($required as $f) {
    if (!isset($originalPostData[$f]) || $originalPostData[$f] === '') {
        http_response_code(400);
        echo json_encode(['status' => false, 'message' => "Missing field: $f"]);
        exit;
    }
}

// --- PASO 1: SIMULAR Y EJECUTAR EL LOGIN ---

// Simulamos la variable $_POST para el script de login.
$_POST = [
    'username' => $user,
    'password' => $pass
];

// Usamos un buffer de salida para capturar cualquier 'echo' del script incluido.
ob_start();
include $loginScriptPath;
$loginResp = ob_get_clean(); // Capturamos la respuesta (debería ser "success").

// El script de login debería haber establecido las variables de sesión si tuvo éxito.
if (trim($loginResp) !== 'success' || empty($_SESSION['user_name'])) {
    http_response_code(403);
    echo json_encode(['status' => false, 'message' => 'Login failed. Check credentials.', 'raw' => $loginResp]);
    exit;
}


// --- PASO 2: SIMULAR Y EJECUTAR LA GENERACIÓN DE LICENCIA ---

// Restauramos y usamos la variable $_POST original para el script de generación.
$_POST = $originalPostData;

// Capturamos la salida del script de generación.
ob_start();
include $genScriptPath;
$resp = ob_get_clean(); // La respuesta debería ser un JSON.


// --- RESPUESTA FINAL ---

// Destruimos la sesión para limpiar.
session_destroy();

// Normalizamos la respuesta JSON.
$json = json_decode($resp, true);
if ($json === null) {
    http_response_code(500);
    echo json_encode(['status' => false, 'message' => 'Non-JSON response from generator', 'raw' => $resp]);
    exit;
}

// Si todo salió bien, respondemos con el JSON del generador.
http_response_code(200);
echo json_encode($json);

?>
