<?php
// Incluir archivos de conexión y funciones
include("include/conn.php");
include("include/function.php");

// Verificar si el usuario ha iniciado sesión
$login = cekSession();
if ($login != 1) {
    http_response_code(403); // Forbidden
    echo 'error: Se requiere autenticación';
    exit();
}

if (isset($_POST['id'])) {
    // Manejar eliminación de una sola licencia
    $id = intval($_POST['id']);
    if ($id > 0) {
        $sql = "UPDATE `users` SET deleted_key = 'yes' WHERE id = ?";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 'i', $id);
        if (mysqli_stmt_execute($stmt)) {
            echo 'success';
        } else {
            echo 'error: Falló la eliminación individual';
        }
        mysqli_stmt_close($stmt);
    } else {
        echo 'error: ID inválido';
    }

} elseif (isset($_POST['ids']) && is_array($_POST['ids'])) {
    // Manejar eliminación de múltiples licencias
    $ids = $_POST['ids'];

    if (empty($ids)) {
        echo 'error: No se proporcionaron IDs';
        exit();
    }

    // Asegurarse de que todos los IDs sean números enteros
    $sanitized_ids = array_map('intval', $ids);
    
    // Filtrar IDs no válidos (como 0)
    $sanitized_ids = array_filter($sanitized_ids, function($id) {
        return $id > 0;
    });

    if (empty($sanitized_ids)) {
        echo 'error: IDs proporcionados no son válidos';
        exit();
    }

    // Crear los marcadores de posición para la consulta SQL (?, ?, ?)
    $placeholders = implode(',', array_fill(0, count($sanitized_ids), '?'));
    
    // Crear la cadena de tipos para bind_param (ej. 'iii')
    $types = str_repeat('i', count($sanitized_ids));

    $sql = "UPDATE `users` SET deleted_key = 'yes' WHERE id IN ($placeholders)";
    $stmt = mysqli_prepare($conn, $sql);
    
    // Vincular los parámetros de forma segura
    mysqli_stmt_bind_param($stmt, $types, ...$sanitized_ids);

    if (mysqli_stmt_execute($stmt)) {
        echo 'success';
    } else {
        echo 'error: Falló la eliminación masiva';
    }
    mysqli_stmt_close($stmt);

} else {
    // Si no se envían los parámetros correctos
    echo 'error: Solicitud inválida';
}

mysqli_close($conn);
?>
