<?php
include("include/conn.php");
include("include/function.php");

session_start(); // Start the session

// Fetch the user id from the session
$user_id = $_SESSION['id'];
$login = cekSession();
if ($login != 1) {
    redirect("login.php");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the new password and confirm password from POST request
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // Check if the passwords match
    if ($new_password !== $confirm_password) {
        echo json_encode(["status" => "error", "message" => "Passwords do not match"]);
        exit;
    }

    // Hash the new password using SHA-1 (note: SHA-1 is not recommended for modern applications)
    $hashed_password = sha1($new_password);

    // Update the password in the database for the current user
    $sql = "UPDATE admin SET password = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $hashed_password, $user_id);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Password updated successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to update the password"]);
    }

    $stmt->close();
    $conn->close();
    exit;
}
?>
<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="Chameleon Admin is a modern Bootstrap 4 webapp &amp; admin dashboard html template with a large number of components, elegant design, clean and organized code.">
    <meta name="keywords" content="admin template, Chameleon admin template, dashboard template, gradient admin template, responsive admin template, webapp, eCommerce dashboard, analytic dashboard">
    <meta name="author" content="ThemeSelect">
    <title id="title"><?= $brandName ?> | Change Password</title>
    <link rel="apple-touch-icon" href="assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">
    <link href="https://maxcdn.icons8.com/fonts/line-awesome/1.1/css/line-awesome.min.css" rel="stylesheet">
    <!-- BEGIN VENDOR CSS-->
    <link rel="stylesheet" type="text/css" href="assets/css/vendors.css">
    <!-- END VENDOR CSS-->
    <!-- BEGIN CHAMELEON  CSS-->
    <link rel="stylesheet" type="text/css" href="assets/css/app-lite.css">
    <!-- END CHAMELEON  CSS-->
    <!-- BEGIN Page Level CSS-->
    <link rel="stylesheet" type="text/css" href="assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="assets/css/core/colors/palette-gradient.css">
    <!-- END Page Level CSS-->
    <!-- BEGIN Custom CSS-->
    <link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <!-- END Custom CSS-->
</head>

<body>
<?php
include("include/header.php");
include("include/sidebar.php");
?>
<style>
    #response-message {
        text-align: center;
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 5px;
        margin-top: 20px;
        font-size: 18px;
        font-weight: bold;
    }

    .success {
        background-color: #4CAF50;
        color: #fff;
        border: 2px solid #45A049;
    }

    .error {
        background-color: #FF5733;
        color: #fff;
        border: 2px solid #D73925;
    }
</style>

<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">Change Password</h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item active">Change Password</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body"><!-- Basic Inputs start -->

            <div class="col-xl-12 col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-block">
                        <form id="change-password-form">
                            <div class="card-body">
                                <fieldset class="form-group">
                                    <h6 class="card-title">New Password</h6>
                                    <input type="password" class="form-control" id="new_password" name="new_password" required>
                                    <h6 class="card-title">Confirm Password</h6>
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                </fieldset>
                                <br>
                                <fieldset class="form-group">
                                    <button type="button" id="add-reseller" class="btn btn-info btn-min-width mr-1 mb-1">Change Password</button>
                                </fieldset>
                            </div>
                        </form>
                        <div id="response-message"></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- ////////////////////////////////////////////////////////////////////////////-->

<?php include("include/footer.php"); ?>
<!-- BEGIN VENDOR JS-->
<script src="assets/vendors/js/vendors.min.js" type="text/javascript"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="assets/js/core/app-menu-lite.js" type="text/javascript"></script>
<script src="assets/js/core/app-lite.js" type="text/javascript"></script>

<script>
$(document).ready(function() {
    $('#add-reseller').on('click', function() {
        // Get the new password and confirm password values
        var newPassword = $('#new_password').val();
        var confirmPassword = $('#confirm_password').val();

        // Perform an AJAX request to update the password
        $.ajax({
            url: '', // The current PHP page handles the request
            type: 'POST',
            data: {
                new_password: newPassword,
                confirm_password: confirmPassword
            },
            dataType: 'json',
            success: function(response) {
                // Display the response message
                var responseDiv = $('#response-message');
                if (response.status === 'success') {
                    responseDiv.removeClass('error').addClass('success');
                } else {
                    responseDiv.removeClass('success').addClass('error');
                }
                responseDiv.text(response.message);
            }
        });
    });
});
</script>
</body>
</html>
